clc; clear; close all;

r = 2;      % fixed
d = 0.2;    % fixed
sigma = 0.432277;  % choose in (d/r, 1). Here d/r = 0.1 so 0.1 < sigma < 1

if ~(r > d)
    error('Theorem 3.4 requires r > d.');
end
if ~(sigma > d/r && sigma < 1)
    error('Theorem 3.4 requires d/r < sigma < 1.');
end


h_vals     = 0.01:0.01:0.35;   % h > 0
alpha_vals = 0.2:0.01:0.97;   % 0 < alpha < 1

[H, A] = meshgrid(h_vals, alpha_vals);

G  = gamma(1 + A);     % Gamma(1+alpha)
h1 = (H.^A) ./ G;      % h1 = h^alpha / Gamma(1+alpha)


% sigma_lower 
sigma_lower = 1 + 1 ./ ( r/(d - r) - (r .* (H.^A)) ./ G );

% sigma_upper 
sigma_upper = (H.^(-A)) .* ( r*(r-d).*(H.^(2*A)) + 2*d.*G.*(H.^A) + 4*r.*(G.^2).*(r-d) )./ ( r*(r-d).*(H.^A) + 2*r.*G );


% Thm 3.4 conditions
% Case 1: 0 < h1 <= 2r AND sigma_lower < sigma < 1
cond1 = (h1 > 0) & (h1 <= 2*r) & (sigma > sigma_lower) & (sigma < 1);

% Case 2: 2r < h1 < h1_max2 AND sigma_lower < sigma < sigma_upper
h1_max2 = 2*sqrt( (-d*r^2 + r^3 + r) / (r - d) ) + 2*r;

cond2 = (h1 > 2*r) & (h1 < h1_max2) & (sigma > sigma_lower) & (sigma < sigma_upper);

% Stable region (Thm 3.4 holds)
STABLE = cond1 | cond2;

figure('Position',[100 100 950 600]);

imagesc(h_vals, alpha_vals, STABLE);
set(gca,'YDir','normal');

colormap(parula);


cb = colorbar;
cb.Ticks = [0 1];
cb.TickLabels = {'Unstable','A.stable'};
cb.FontSize = 18;
cb.FontWeight = 'bold';

xlabel('h','FontSize',13,'FontWeight','bold');
ylabel('\alpha','FontSize',13,'FontWeight','bold');


set(gca,'FontSize',20,'FontWeight','bold','LineWidth',1.5);

hold on;

contour(h_vals, alpha_vals, sigma_lower,[sigma sigma], 'k', 'LineWidth', 2, 'DisplayName', '\sigma = \sigma^*');

h0 = 0.3;
alpha0 = 0.95;

plot(h0, alpha0, 'ro', 'MarkerSize', 9,  'MarkerFaceColor', 'r', 'DisplayName', '(h,\alpha) = (0.3, 0.95)');

legend('Location','northwest','FontSize',20);
hold off;
